//=============================================================================
// SoyMeal.
//=============================================================================
class NumMeal extends MSMTLSoyMeals;

#exec TEXTURE IMPORT NAME="NumMeal1" FILE="C:\DeusEx\MarkistanCity\Textures\NumMeal1.pcx" GROUP=Skins
#exec TEXTURE IMPORT NAME="NumMeal2" FILE="C:\DeusEx\MarkistanCity\Textures\NumMeal2.pcx" GROUP=Skins
#exec TEXTURE IMPORT NAME="NumMeal3" FILE="C:\DeusEx\MarkistanCity\Textures\NumMeal3.pcx" GROUP=Skins

#exec TEXTURE IMPORT NAME=BeltIconSoyMealP FILE=Textures\IconSoyMealP.PCX GROUP=Icons FLAGS=2 //Belt


function inventory SpawnCopy( pawn Other )
{
	local inventory Copy;

	Copy = Super.SpawnCopy(Other);
	Copy.bTossedOut = False;

	return Copy;
}

function DropFrom(vector StartLocation)
{

   if (Level.Netmode != NM_Standalone)
      bTossedOut = true;
	Super.DropFrom(StartLocation);
}

function BecomePickup()
{
	Super.BecomePickup();

   if (Level.NetMode != NM_Standalone)
      if (bTossedOut)
         Lifespan = 15.0;
}

defaultproperties
{
     healAmount=40
     maxCopies=8
     bCanHaveMultipleCopies=True
     InventoryGroup=171
     bActivatable=True
     ItemName="Meat Meal"
     PlayerViewOffset=(X=30.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'DeusExItems.SoyFood'
     PickupViewMesh=LodMesh'DeusExItems.SoyFood'
     ThirdPersonMesh=LodMesh'DeusExItems.SoyFood'
     Icon=Texture'BeltIconSoyMealP'
     largeIconWidth=42
     largeIconHeight=46
     Description="A new meat meal produced by Communist Russians, it claims to be so much more Yummy than YUM! Meals, that it's in fact Nummy. This one's Purple."
     beltDescription="MEAT MEAL P"
     Skin=Texture'MarkistanCity.Skins.NumMeal1'
     Mesh=LodMesh'DeusExItems.SoyFood'
     CollisionRadius=8.000000
     CollisionHeight=0.980000
     Mass=3.000000
     Buoyancy=4.000000
}
